#!/bin/sh

DELAY=2
TOKEN=$(cat token.txt)

MSG_START="Welcome to the voice-changing Telegram bot! Based on the SoX app. Use \"/help\" to get help."
MSG_HELP="---
This bot uses the SoX app functionality.
Available commands:
/start - start the bot.
/help - this message.
/effset [effect [effopt]] [effect [effopt]]... - set or delete the commandline for the SoX app.
/effget - read the current commandline.
/effexamples - list of examples.
Send the voice message to the bot and it will change the voice according to the current commandline.
EFFECTS: allpass band bandpass bandreject bass bend biquad chorus channels compand contrast dcshift deemph delay dither divide+ downsample earwax echo echos equalizer fade fir firfit+ flanger gain highpass hilbert input# ladspa loudness lowpass mcompand noiseprof noisered norm oops output# overdrive pad phaser pitch rate remix repeat reverb reverse riaa silence sinc spectrogram speed splice stat stats stretch swap synth tempo treble tremolo trim upsample vad vol
---"

MSG_EFFEXAMPLES="---
/eff_highvoice - Helium Baloon (pitch +600)
/eff_lowvoice - Hexaphtoride Baloon (pitch -600)
/eff_demon - Evil Demonic Voice (echo 0.8 0.88 50 0.4 pitch -250)
/eff_reverse - Reverse the message (reverse)
/eff_echo4 - Echo 4 (echo 0.8 0.5 250 0.3 echo 0.8 0.4 500 0.3)
/eff_smallalien - Small Alien (pitch +150 phaser 0.6 0.66 3 0.6 2 -t)
/eff_bigalien - Big Alien (pitch -150 phaser 0.6 0.66 3 0.6 2 -t)
/eff_ghost - Ghost (reverse reverb reverse)
---"

mkdir -p cache

while true
do
	updates=$(curl https://api.telegram.org/bot$TOKEN/getUpdates?limit=1 | jq .result[])
	if test -z "$updates"
	then
		sleep 1
	else
		updateid=$(echo $updates | jq .update_id)
		chat_id=$(echo $updates | jq .message.chat.id)
		message_id=$(echo $updates | jq .message.message_id)
		from=$(echo $updates | jq .message.from)
		userid=$(echo $from | jq .id)
		mkdir -p cache/$userid
		echo $from | jq . > cache/$userid/user.json
		text=$(echo $updates | jq .message.text | cut -d "\"" -f 2)

		command=$(echo $text | cut -d " " -f 1)
		command=$command@
		command=$(echo $command | cut -d "@" -f 1)
		case $command in

			"/start" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=$MSG_START" https://api.telegram.org/bot$TOKEN/sendMessage) ;;

			"/help" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=$MSG_HELP" https://api.telegram.org/bot$TOKEN/sendMessage) ;;

			"/effget" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=$(cat cache/$userid/sox.txt)" https://api.telegram.org/bot$TOKEN/sendMessage) ;;

			"/effexamples" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=$MSG_EFFEXAMPLES" https://api.telegram.org/bot$TOKEN/sendMessage) ;;

			"/eff_highvoice" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Helium Baloon (pitch +600)" https://api.telegram.org/bot$TOKEN/sendMessage) 
				echo "pitch +600" > cache/$userid/sox.txt;;

			"/eff_lowvoice" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Hexaphtoride Baloon (pitch -600)" https://api.telegram.org/bot$TOKEN/sendMessage) 
				echo "pitch -600" > cache/$userid/sox.txt;;

			"/eff_demon" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Evil Demonic Voice (echo 0.8 0.88 50 0.4 pitch -250)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "echo 0.8 0.88 50 0.4 pitch -250" > cache/$userid/sox.txt;;

			"/eff_reverse" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Reverse the message (reverse)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "reverse" > cache/$userid/sox.txt;;

			"/eff_echo4" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Echo 4 (echo 0.8 0.5 250 0.3 echo 0.8 0.4 500 0.3)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "echo 0.8 0.5 250 0.3 echo 0.8 0.4 500 0.3" > cache/$userid/sox.txt;;

			"/eff_smallalien" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Small Alien (pitch +150 phaser 0.6 0.66 3 0.6 2 -t)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "pitch +150 phaser 0.6 0.66 3 0.6 2 -t" > cache/$userid/sox.txt;;
			"/eff_bigalien" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Big Alien (pitch -150 phaser 0.6 0.66 3 0.6 2 -t)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "pitch -150 phaser 0.6 0.66 3 0.6 2 -t" > cache/$userid/sox.txt;;

			"/eff_ghost" )
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id" --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=Ghost (reverse reverb reverse)" https://api.telegram.org/bot$TOKEN/sendMessage)
				echo "reverse reverb reverse" > cache/$userid/sox.txt;;

			"/effset" )
				cmdline=$(echo $text | cut -d " " -f 2-)
				cmdline=$(echo $cmdline | cut -d ";" -f 1)
				echo $cmdline > cache/$userid/sox.txt
				sendmsg=$(curl --data-urlencode "chat_id=$chat_id"  --data-urlencode "reply_to_message_id=$message_id" --data-urlencode "text=$cmdline" https://api.telegram.org/bot$TOKEN/sendMessage)
			;;

			* )
				voicein_id=$(echo $updates | jq .message.voice.file_id | cut -d "\"" -f 2)
				voicein_path=$(curl https://api.telegram.org/bot$TOKEN/getFile?file_id=$voicein_id | jq .result.file_path | cut -d "\"" -f 2)
				curl --output cache/$userid/voicein.ogg https://api.telegram.org/file/bot$TOKEN/$voicein_path
				ffmpeg -y -i cache/$userid/voicein.ogg cache/$userid/voicein.wav
				sox cache/$userid/voicein.wav cache/$userid/voiceout.wav $(cat cache/$userid/sox.txt)
				ffmpeg -y -i cache/$userid/voiceout.wav -ac 1 -map 0:a -codec:a libopus -b a:128k -vbr off -ar 24000 cache/$userid/voiceout.ogg
				curl -F "voice=@cache/$userid/voiceout.ogg" https://api.telegram.org/bot$TOKEN/sendVoice?chat_id=$chat_id\&reply_to_message_id=$message_id
				rm cache/$userid/voice*
				
				
		esac

		upd_drop=$((updateid+1))
		echo ___ $updateid ___ $upd_drop
		echo ___ $updates
		curl https://api.telegram.org/bot$TOKEN/getUpdates?offset=$upd_drop
	fi
	sleep $DELAY
	
done
